// VERSION: Scilab: 5.4.1 
// OS: windows 7 
//CAPTION: PROGRAM TO OBSERVE THE EFFECTS OF LOWER SAMPLING RATE AND
// HIGHER SAMPLING RATE ON C.T. SIGNAL(SAMPLING THM.)

clc;
clear;
close;
f=input('Enter continuous time signal frequency=');// f=0.1
a=input('Enter continuous time signal amplitude=');//a=1
t=0:0.01:100;
x=a*sin(2*%pi*f*t);
subplot(2,2,1);
b=gca();
b.x_location="origin";
b.y_location="origin";
b.foreground = 5; 
b.font_color = 5;
b.font_style = 5;
plot(t,x);
title('Original Continuous time Signal');
xlabel('Time t');
ylabel('Amplitude');

// Sampling Rate=2*max frequency
fs1=input('Enter sampling frequency equal to 2*fs=');//fs1=0.2
fd=f/fs1;
n=0:0.01:100;
x1n=a*sin(2*%pi*f*n/fs1);
subplot(2,2,2);
b=gca();
b.x_location="origin";
b.y_location="origin";
b.foreground = 5; 
b.font_color = 5;
b.font_style = 5;
plot2d3('gnn',n,x1n);
title('Reconstructed signal with sampling frequency equal 2*fs');
xlabel('Time t');
ylabel('Amplitude');


// Sampling Rate<2*max frequency= Aliasing Effect
fs2=input('Enter sampling frequency less than 2*fs=');//fs2=0.1
x2n=a*sin(2*%pi*f*n/fs2);
subplot(2,2,3);
b=gca();
b.x_location="origin";
b.y_location="origin";
b.foreground = 5; 
b.font_color = 5;
b.font_style = 5;
plot2d3('gnn',n,x2n);
title('Reconstructed signal with sampling frequency Less than 2*fs=Aliasing effect');
xlabel('Time t');
ylabel('Amplitude');

// Sampling Rate>2*max frequency=Perfect Reconstuection
fs3=input('Enter sampling frequency Greater than 2*fs=');//fs3=1
x3n=a*sin(2*%pi*f*n*fs3);
subplot(2,2,4);
b=gca();
b.x_location="origin";
b.y_location="origin";
b.foreground = 5; 
b.font_color = 5;
b.font_style = 5;
plot2d3('gnn',n,x3n);
title('Perfect Reconstructed signal with sampling frequency greater than 2*fs');
xlabel('Time t');
ylabel('Amplitude');

//INPUT:
//Enter continuous time signal frequency=0.1
//Enter continuous time signal amplitude=1
//Enter sampling frequency equal to 2*fs=0.2
//Enter sampling frequency less than 2*fs=0.1
//Enter sampling frequency Greater than 2*fs=1
